<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Contracts\Validation\Validator;

class UserLoginRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
                'username' => 'required',
                'password' => 'required|string',
        ];
    }

      protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(
            msgdata(false, trans('lang.there_is_some_errors'), $validator->errors()->all(), validation())
        );
    }
}
