<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class Voter extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'national_id',
        'candidate_id',
        'is_vote',
        'is_confirm',
        'created_by',
        'confirm_by',
    ];

    protected $casts = [
        'is_vote' => 'boolean',
        'is_confirm' => 'boolean',
    ];

    public function candidate()
    {
        return $this->belongsTo(Candidate::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function confirmBy()
    {
        return $this->belongsTo(User::class, 'confirm_by');
    }
}
