@extends('layout.layout')

@php
    $route = 'all-articles';
@endphp

@section('title', __('lang.all') . ' ' . __('lang.articles'))

@section('header')
    <h1 class="text-dark fw-bolder my-0 fs-2">{{ __('lang.all') }} {{ __('lang.articles') }}</h1>

    <ul class="breadcrumb fw-bold fs-base my-1">
        <li class="breadcrumb-item">
            <a href="{{ url('/') }}" class="text-muted">{{ __('lang.Dashboard') }}</a>
        </li>
        <li class="breadcrumb-item">{{ __('lang.all') }} {{ __('lang.articles') }}</li>
    </ul>
@endsection

@section('content')

<div id="kt_content_container" class="flex-column-fluid align-items-start container-xxl">

    <div class="content flex-row-fluid" id="kt_content">

        <div class="card">

            <div class="card-body pt-0">

                <div class="table-responsive">

                    <table class="table align-middle table-row-bordered text-start fs-4 gy-5" id="all_articles_table">

                        <thead>
                        <tr class="bg-secondary text-dark fw-bolder fs-5 text-capitalize gs-0">

                            <th class="w-10px pe-2">
                                <div class="form-check form-check-sm form-check-custom form-check-solid me-3">
                                    <input class="form-check-input" type="checkbox"
                                           data-kt-check="true"
                                           data-kt-check-target="#all_articles_table .checkbox"
                                           value="1"/>
                                </div>
                            </th>

                            <th class="min-w-125px">{{ __('lang.title') }}</th>
                            <th class="min-w-125px">{{ __('lang.keyword') }}</th>
                            <th class="min-w-125px">{{ __('lang.batch') }}</th>
                            <th class="min-w-125px">{{ __('lang.site') }}</th>
                            <th class="min-w-125px">{{ __('lang.Generation_status') }}</th>
                            <th class="min-w-125px">{{ __('lang.Publish_status') }}</th>
                            <th class="min-w-125px">{{ __('lang.actions') }}</th>

                        </tr>
                        </thead>

                    </table>

                </div>

            </div>

        </div>

    </div>

</div>

@endsection

@section('script')

<script src="{{ asset('assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>

<script>
    $(function () {

        var table = $('#all_articles_table').DataTable({
            processing: true,
            serverSide: true,
            autoWidth: true,
            aaSorting: [],
            "dom":
                "<'card-header border-0 p-0 pt-6'<'card-title' <'d-flex align-items-center position-relative my-1'f>>" +
                "<'card-toolbar' <'d-flex justify-content-end add_button'B>>" +
                "r>" +
                "<'row'l>" +
                "t" +
                "<'row'<'col-md-5'i><'col-md-7'p>>",

            lengthMenu: [
                [10, 25, 50, 100, -1],
                [10, 25, 50, 100, "{{ __('lang.all') }}"]
            ],

            language: {
                search: '<i class="fa fa-search"></i>',
                searchPlaceholder: '{{ __("lang.search") }}',
                url: "@if(Session('lang') == 'ar') //cdn.datatables.net/plug-ins/1.13.6/i18n/ar.json @endif"
            },

            buttons: [
                {
                    extend: 'excel',
                    className: 'btn btn-primary',
                    text: '<i class="bi bi-file-earmark-spreadsheet-fill fs-2x"></i>',
                },
                {
                    extend: 'print',
                    className: 'btn btn-primary',
                    text: '<i class="bi bi-printer-fill fs-2x"></i>',
                }
            ],

            ajax: "{{ route('all-articles.datatable') }}",

            columns: [
                { data: 'checkbox', name: 'checkbox' },
                { data: 'source_title', name: 'source_title' },
                { data: 'focus_keyword', name: 'focus_keyword' },
                { data: 'batch_id', name: 'batch_id' },
                { data: 'site_id', name: 'site_id' },
                { data: 'generation_status', name: 'generation_status' },
                { data: 'publish_status', name: 'publish_status' },
                { data: 'actions', name: 'actions', searchable: false, orderable: false },
            ]
        });

    });
</script>

@endsection
