<div class="card mt-10">
    <div class="card-header">
        <h3 class="fw-bold">Logs</h3>
    </div>

    <div class="card-body">

        @forelse($logs as $log)

            <div class="border rounded p-5 mb-5 bg-light">

                <p class="fw-bold text-primary">[{{ strtoupper($log->level) }}] - {{ $log->action }}</p>

                <p class="mb-3">{{ $log->message }}</p>

                @if($log->payload)
                    <pre class="bg-white p-5 rounded">{{ json_encode($log->payload, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE) }}</pre>
                @endif

                <small class="text-muted">Created at: {{ $log->created_at }}</small>

            </div>

        @empty

            <p class="text-center text-muted">No logs available</p>

        @endforelse

    </div>

</div>
