@extends('layout.layout')

@section('title')
    {{__('lang.General Setting')}}
@endsection

@section('content')

    <!--begin::Entry-->
        <!--begin::Container-->

        <div class="container">
         <!--begin::Card-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-3">
                    <div class="card-title">
                        <h3 class="card-label">{{__('lang.General Setting')}}
                    </div>
                </div>
                <div class="card-body">
                    <form method="post" action="{{url('settings/update')}}" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="kt-section__body">

{{-- Tabs للغات --}}
<ul class="nav nav-tabs mb-3" role="tablist">
  <li class="nav-item"><button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab-ar" type="button" role="tab">العربية</button></li>
  <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-en" type="button" role="tab">English</button></li>
</ul>

<div class="tab-content">
  {{-- العربية --}}
  <div class="tab-pane fade show active" id="tab-ar" role="tabpanel">
      <div class="mb-3">
          <label class="form-label">العنوان (AR)</label>
          <textarea name="title[ar]" class="form-control" rows="2">{{ old('title.ar', isset($data) ? $data->getTranslation('title','ar') : '') }}</textarea>
          @error('title.ar')<small class="text-danger">{{ $message }}</small>@enderror
      </div>
      <div class="mb-3">
          <label class="form-label">الوصف المختصر (AR)</label>
          <textarea name="short_description[ar]" class="form-control" rows="3">{{ old('short_description.ar', isset($data) ? $data->getTranslation('short_description','ar') : '') }}</textarea>
          @error('short_description.ar')<small class="text-danger">{{ $message }}</small>@enderror
      </div>
  </div>

  {{-- الإنجليزية --}}
  <div class="tab-pane fade" id="tab-en" role="tabpanel">
      <div class="mb-3">
          <label class="form-label">Title (EN)</label>
          <textarea name="title[en]" class="form-control" rows="2">{{ old('title.en', isset($data) ? $data->getTranslation('title','en') : '') }}</textarea>
          @error('title.en')<small class="text-danger">{{ $message }}</small>@enderror
      </div>
      <div class="mb-3">
          <label class="form-label">Short Description (EN)</label>
          <textarea name="short_description[en]" class="form-control" rows="3">{{ old('short_description.en', isset($data) ? $data->getTranslation('short_description','en') : '') }}</textarea>
          @error('short_description.en')<small class="text-danger">{{ $message }}</small>@enderror
      </div>
  </div>
</div>  


            <div class="col-md-12">
                <label class="form-label">العنوان</label>
                <input type="text" name="address" class="form-control" value="{{ old('address', $data->address ?? '') }}">
                @error('address')<small class="text-danger">{{ $message }}</small>@enderror
            </div>

            <div class="col-md-12">
                <label class="form-label">البريد الإلكتروني</label>
                <input type="email" name="email" class="form-control" value="{{ old('email', $data->email ?? '') }}">
                @error('email')<small class="text-danger">{{ $message }}</small>@enderror
            </div>

            <div class="col-md-12">
                <label class="form-label">رقم الهاتف</label>
                <input type="text" name="phone" class="form-control" value="{{ old('phone', $data->phone ?? '') }}">
                @error('phone')<small class="text-danger">{{ $message }}</small>@enderror
            </div>

            <div class="col-md-12">
                <label class="form-label">YouTube</label>
                <input type="url" name="youtube" class="form-control" value="{{ old('youtube', $data->youtube ?? '') }}">
                @error('youtube')<small class="text-danger">{{ $message }}</small>@enderror
            </div>

            <div class="col-md-12">
                <label class="form-label">Twitter/X</label>
                <input type="url" name="twitter" class="form-control" value="{{ old('twitter', $data->twitter ?? '') }}">
                @error('twitter')<small class="text-danger">{{ $message }}</small>@enderror
            </div>

            <div class="col-md-12">
                <label class="form-label">Instagram</label>
                <input type="url" name="instagram" class="form-control" value="{{ old('instagram', $data->instagram ?? '') }}">
                @error('instagram')<small class="text-danger">{{ $message }}</small>@enderror
            </div>

            <div class="col-md-12">
                <label class="form-label">Android Link (Google Play)</label>
                <input type="url" name="android_link" class="form-control" value="{{ old('android_link', $data->android_link ?? '') }}">
                @error('android_link')<small class="text-danger">{{ $message }}</small>@enderror
            </div>

            <div class="col-md-12">
                <label class="form-label">iOS Link (App Store)</label>
                <input type="url" name="ios_link" class="form-control" value="{{ old('ios_link', $data->ios_link ?? '') }}">
                @error('ios_link')<small class="text-danger">{{ $message }}</small>@enderror
            </div>
                                </div>
                            </div>

                            <div class="col-xl-12">
                                <div class="kt-section__body">

                                    <div class="form-group row">
                                        <label class="col-xl-3 col-lg-3 col-form-label">@if(session('lang') == 'ar')
                                            اللوجو@else  Logo @endif</label>
                                        <div class="col-lg-12 col-xl-12">
                                            <div class="card">
                                                <div class="card-block">
                                                    <h4 class="card-title"></h4>
                                                    <div class="controls">
                                                        <input type="file" id="input-file-now" class="dropify" name="logo" data-default-file="{{asset($Setting->logo)}}" name="logo"   data-validation-required-message="{{trans('word.This field is required')}}"/>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-xl-3 col-lg-3 col-form-label">@if(session('lang') == 'ar')
                                            Favicon @else  Favicon @endif</label>
                                        <div class="col-lg-12 col-xl-12">
                                            <div class="card">
                                                <div class="card-block">
                                                    <h4 class="card-title"></h4>
                                                    <div class="controls">
                                                        <input type="file" name="favicon" id="input-file-now" class="dropify"  data-default-file="{{asset($Setting->favicon)}}" name="logo"   data-validation-required-message="{{trans('word.This field is required')}}"/>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">{{__('lang.save')}}</button>
                        </div>
                    </form>
                </div>
            </div>
            <!--end::Card-->
        </div>
        <!--end::Container-->








@section('script')
{{--    <script src="{{asset('assets/plugins/custom/ckeditor/ckeditorv4.js')}}"></script>--}}
    <script src="https://cdn.ckeditor.com/4.22.1/full/ckeditor.js"></script>

    <script>
        CKEDITOR.replace( 'editor1' );
        CKEDITOR.replace( 'editor2' );
        CKEDITOR.replace( 'editor3' );
        CKEDITOR.replace( 'editor4' );

    </script>

    <script>

        $("#checker").click(function(){
            var items = document.getElementsByTagName("input");

            for(var i=0; i<items.length; i++){
                if(items[i].type=='checkbox') {
                    if (items[i].checked==true) {
                        items[i].checked=false;
                    } else {
                        items[i].checked=true;
                    }
                }
            }

        });

        //Delete Row
        $("body").on("click", "#delete", function () {
            var dataList = [];
            dataList = $("#kt_datatable input:checkbox:checked").map(function(){
                return $(this).val();
            }).get();

            if(dataList.length >0){
                Swal.fire({
                    title: "{{trans('word.Are you sure?')}}",
                    text: "",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "{{trans('word.Yes, Sure it!')}}",
                    cancelButtonText: "{{trans('word.No')}}",
                    closeOnConfirm: false,
                    closeOnCancel: false
                }).then(function (result) {
                    if (result.value) {
                        var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
                        $.ajax({
                            url:'{{url("Delete_Language")}}',
                            type:"get",
                            data:{'id':dataList,_token: CSRF_TOKEN},
                            dataType:"JSON",
                            success: function (data) {
                                if(data.message == "Success")
                                {
                                    $("#kt_datatable .selected").hide();
                                    @if( Request::segment(1) == "ar")
                                    $('#delete').text('حذف 0 سجل');
                                    @else
                                    $('#delete').text('Delete 0 row');
                                    @endif
                                    Swal.fire("{{trans('word.Deleted')}}", "{{trans('word.Message_Delete')}}", "success");
                                    location.reload();
                                }else{
                                    Swal.fire("{{trans('word.Sorry')}}", "{{trans('word.Message_Fail_Delete')}}", "error");
                                }
                            },
                            fail: function(xhrerrorThrown){
                                Swal.fire("{{trans('word.Sorry')}}", "{{trans('word.Message_Fail_Delete')}}", "error");
                            }
                        });
                        // result.dismiss can be 'cancel', 'overlay',
                        // 'close', and 'timer'
                    } else if (result.dismiss === 'cancel') {
                        Swal.fire("{{trans('word.Cancelled')}}", "{{trans('word.Message_Cancelled_Delete')}}", "error");
                    }
                });
            }
        });

        $(document).ready(function() {
            // Basic
            $('.dropify').dropify({
            messages: {
                'default': "{{trans('lang.dropify-default')}}",
                'replace': "{{trans('lang.dropify-replace')}}",
                'remove':  "{{trans('lang.dropify-remove')}}",
                'error':   "{{trans('lang.dropify-error')}}"
            }
        });

            // Used events
            var drEvent = $('#input-file-events').dropify();

            drEvent.on('dropify.beforeClear', function(event, element) {
                return confirm("Do you really want to delete \"" + element.file.name + "\" ?");
            });

            drEvent.on('dropify.afterClear', function(event, element) {
                alert('File deleted');
            });

            drEvent.on('dropify.errors', function(event, element) {
                console.log('Has Errors');
            });

            var drDestroy = $('#input-file-to-destroy').dropify();
            drDestroy = drDestroy.data('dropify')
            $('#toggleDropify').on('click', function(e) {
                e.preventDefault();
                if (drDestroy.isDropified()) {
                    drDestroy.destroy();
                } else {
                    drDestroy.init();
                }
            })
        });

        //End Delete Row
        $(".edit-Advert").click(function(){
            var id=$(this).data('id')
            var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
            $.ajax({
                type: "GET",
                url: "{{url('Edit_Language')}}",
                data: {"id":id},
                success: function (data) {
                    $(".bs-edit-modal-lg .modal-body").html(data)
                    $(".bs-edit-modal-lg").modal('show')
                    $(".bs-edit-modal-lg").on('hidden.bs.modal',function (e){
                        //   $('.bs-edit-modal-lg').empty();
                        $('.bs-edit-modal-lg').hide();
                    })
                }
            })
        })

        $(".switchery-demo").click(function(){
            var id =$(this).data('id');
            console.log(id);
            $.ajax({
                type: "get",
                url: "{{url('UpdateStatusUser')}}",
                data: {"id":id },
                success: function (data) {
                    Swal.fire({
                        icon: 'success',
                        title: "@if(Request::segment(1)=='ar')  نجاح @else success @endif",
                        text: "@if(Request::segment(1) == 'ar' ) تم التعديل بنجاح   @else Successfully changed @endif",
                        type:"success" ,
                        timer: 1000,
                        showConfirmButton: false
                    });


                }
            })
        })
    </script>

    <?php
    $message=session()->get("message");
    ?>



    @if( session()->has("message"))
        @if( $message == "Success")
            <script>
                Swal.fire({
                    icon: 'success',
                    title: "{{__('lang.Success')}}",
                    text: "{{__('lang.Success_text')}}",
                    type:"success" ,
                    timer: 1000,
                    showConfirmButton: false
                });

            </script>
        @elseif ( $message == "Failed")
            <script>
                Swal.fire({
                    icon: 'warning',
                    title: "{{__('lang.Sorry')}}",
                    text: "{{__('lang.operation_failed')}}",
                    type:"error" ,
                    timer: 2000,
                    showConfirmButton: false
                });
            </script>
        @endif
    @endif
@endsection
@endsection
