@extends('layout.layout')

@php
    $route = 'sites';
@endphp

@section('title', __('lang.sites'))

@section('header')
    <h1 class="text-dark fw-bolder my-0 fs-2">{{ __('lang.sites') }}</h1>

    <ul class="breadcrumb fw-bold fs-base my-1">
        <li class="breadcrumb-item"><a href="{{ url('/') }}" class="text-muted">{{ __('lang.Dashboard') }}</a></li>
        <li class="breadcrumb-item">{{ __('lang.sites') }}</li>
    </ul>
@endsection

@section('content')

<div id="kt_content_container" class="flex-column-fluid align-items-start container-xxl">

    <div class="content flex-row-fluid" id="kt_content">

        <div class="card">

            {{-- Header --}}
            {{-- <div class="card-header border-0 pt-6">
                <div class="card-title"></div>
                <div class="card-toolbar add_button"></div>
            </div> --}}

            {{-- Body --}}
            <div class="card-body pt-0">

                <div class="table-responsive">
                    <table class="table align-middle table-row-bordered text-start fs-4 gy-5" id="sites_table">

                        <thead>
                        <tr class="bg-secondary text-dark fw-bolder fs-5 gs-0">
                            <th class="w-10px">
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input" type="checkbox" data-kt-check="true"
                                           data-kt-check-target="#sites_table .checkbox"/>
                                </div>
                            </th>

                            <th class="min-w-125px">Name</th>
                            <th class="min-w-125px">Domain</th>
                            <th class="min-w-125px">AI Provider</th>
                            <th class="min-w-125px">{{ __('lang.active') }}</th>
                            <th class="min-w-125px">{{ __('lang.Actions') }}</th>
                        </tr>
                        </thead>

                    </table>
                </div>

            </div>

        </div>

    </div>
</div>

@endsection


@section('script')

<script src="{{ asset('assets/plugins/custom/datatables/datatables.bundle.js')}}"></script>

<script>
$(function () {

    var table = $('#sites_table').DataTable({
        processing: true,
        serverSide: true,
        autoWidth: true,
        aaSorting: [],
        dom:
            "<'card-header border-0 pt-6'<'card-title'f><'card-toolbar add_button'B>>" +
            "r" +
            "t" +
            "<'row'<'col-md-5'i><'col-md-7'p>>",

        buttons: [],

        ajax: "{{ route('sites.datatable') }}",

        columns: [
            { data: 'checkbox', name: 'checkbox' },
            { data: 'name', name: 'name' },
            { data: 'domain', name: 'domain' },
            { data: 'ai_provider', name: 'ai_provider' },
            { data: 'is_active', name: 'is_active' },
            { data: 'actions', name: 'actions', orderable: false, searchable: false },
        ]
    });

    // load add-button via AJAX
    $.ajax({
        url: "{{ route('sites.add-button') }}",
        success: function (data) {
            $('.add_button').html(data);
        }
    });

    // Delete row
    $(document).on('click', '.delete-row', function () {
        let id = $(this).data('id');
        if (!confirm("Delete this site?")) return;

        $.get("{{ route('sites.delete') }}", { id: id }, function () {
            table.ajax.reload();
        });
    });

    // Change Active
    $(document).on('change', '.change-active', function () {
        let id = $(this).data('id');

        $.post(
            "{{ route('sites.change_active') }}",
            { id: id, status: this.checked ? 1 : 0, _token: "{{ csrf_token() }}" },
            function () { table.ajax.reload(); }
        );
    });

});
</script>

@endsection
