@extends('layout.layout')
@php $route = 'subCategories'; @endphp
@section('title', __('lang.subCategories'))
@section('header')
    <h1 class="text-dark fw-bolder my-0 fs-2">{{ __('lang.' . $route) }}</h1>
    <ul class="breadcrumb fw-bold fs-base my-1">
        <li class="breadcrumb-item">
            <a href="{{ url('/') }}" class="text-muted">{{ __('lang.Dashboard') }}</a>
        </li>
        <li class="breadcrumb-item">{{ __('lang.' . $route) }}</li>
    </ul>
@endsection
@section('content')
    <div id="kt_content_container" class="d-flex flex-column-fluid align-items-start container-xxl">
        <div class="content flex-row-fluid" id="kt_content">
            <div class="card">
                <div class="card-body pt-0">
                    <table class="table align-middle table-row-bordered text-start fs-4 gy-5" id="categories_table">
                        <thead>
                        <tr class="bg-secondary text-dark fw-bolder fs-5 text-capitalize gs-0">
                            <th class="w-10px pe-2">
                                <div class="form-check form-check-sm form-check-custom form-check-solid me-3">
                                    <input class="form-check-input" type="checkbox" data-kt-check="true" data-kt-check-target="#categories_table .checkbox" value="1" />
                                </div>
                            </th>
                            <th class="min-w-125px">{{ __('lang.name') }}</th>
                            <th class="min-w-125px">{{ __('lang.status') }}</th>
                            <th class="min-w-125px">{{ __('lang.image') }}</th>
                            <th class="min-w-125px">{{ __('lang.Actions') }}</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $(function () {
            let table = $('#categories_table').DataTable({
                processing: true,
                serverSide: true,
                autoWidth: false,
                responsive: true,
                aaSorting: [],
                dom: "<'card-header border-0 p-0 pt-6'<'card-title'<'d-flex align-items-center position-relative my-1'f>>r<'card-toolbar'<'d-flex justify-content-end add_button'B>>r><'row'l><'table-responsive't><'row'<'col-md-5'i><'col-md-7'p>>",
                language: {
                    search: '<i class="fa fa-search"></i>',
                    searchPlaceholder: '{{ __("lang.search") }}',
                    url: "@if(Session('lang') == 'ar') //cdn.datatables.net/plug-ins/1.13.6/i18n/ar.json @endif"
                },
                buttons: [
                    {
                        extend: 'excel',
                        className: 'btn btn-primary me-3',
                        text: '<i class="bi bi-file-earmark-spreadsheet-fill fs-2x"></i>',
                        titleAttr: "{{ __('lang.excel') }}",
                        exportOptions: {
                            columns: ':visible'
                        }
                    },
                    {
                        extend: 'print',
                        className: 'btn btn-primary me-3',
                        text: '<i class="bi bi-printer-fill fs-2x"></i>',
                        titleAttr: "{{ __('lang.print') }}",
                        customize: function (win) {
                            $(win.document.body).css('direction', '{{ __("lang.lang-direction") }}');
                        },
                        exportOptions: {
                            columns: ':visible',
                            stripHtml: false
                        }
                    }
                ],
                ajax: {
                    url: '{{ route($route . ".datatable",$id) }}'
                },
                columns: [
                    { data: 'checkbox', name: 'checkbox', orderable: false, searchable: false },
                    { data: 'title', name: 'title' },
                    { data: 'status', name: 'status' },
                    { data: 'image', name: 'image', orderable: false, searchable: false },
                    { data: 'actions', name: 'actions', orderable: false, searchable: false },
                ]
            });

            $.ajax({
                url: "{{ route($route.'.add-button',$id) }}",
                success: function (data) {
                    $('.add_button').append(data);
                },
                dataType: 'html'
            });
        });
    </script>
@endsection

