@extends('layout.layout')

@php
    $route = 'users';
@endphp

@section('header')
    <h1 class="text-dark fw-bolder my-0 fs-2">{{ __('lang.edit') }}</h1>

    <ul class="breadcrumb fw-bold fs-base my-1">
        <li class="breadcrumb-item">
            <a href="{{ url('/') }}" class="text-muted">{{ __('lang.Dashboard') }}</a>
        </li>

        <li class="breadcrumb-item">
            <a href="{{ route($route.'.index') }}" class="text-muted">{{ __('lang.users') }}</a>
        </li>

        <li class="breadcrumb-item">
            {{ __('lang.edit') }}
        </li>
    </ul>
@endsection


@section('content')

<div id="kt_content_container" class="d-flex flex-column-fluid align-items-start container-xxl">

    <div class="content flex-row-fluid" id="kt_content">

        <div class="card mb-5 mb-xl-10">

            <div class="card-header border-0">
                <div class="card-title m-0">
                    <h3 class="fw-bolder m-0">{{ __('lang.Users_Edit') }}</h3>
                </div>
            </div>

            <div id="kt_account_settings_profile_details" class="collapse show">

                <form action="{{ route($route.'.update', $data->id) }}"
                      class="form"
                      method="post"
                      enctype="multipart/form-data">
                    @csrf

                    <div class="card-body border-top p-9">

                        @include('admin.users.form')

                    </div>

                    <div class="card-footer d-flex justify-content-end py-6 px-9">
                        <button type="submit" class="btn btn-primary">{{ __('lang.save') }}</button>
                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

@endsection

@section('script')
    <!-- No extra scripts needed for Users Edit -->
@endsection
